   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.30  10/19/06            */
   /*                                                     */
   /*                 NETWORK HEADER FILE                 */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.30: Added support for hashed alpha memories.       */
/*                                                           */
/*************************************************************/

#ifndef _H_network

#define _H_network

struct patternNodeHeader;
struct joinNode;
struct alphaMemoryHash;

#ifndef _H_match
#include "match.h"
#endif

#ifndef _H_expressn
#include "expressn.h"
#endif

struct patternNodeHeader
  {
   struct alphaMemoryHash *firstHash;
   struct alphaMemoryHash *lastHash;
   struct joinNode *entryJoin;
   struct expr *rightHash;
   unsigned int singlefieldNode : 1;
   unsigned int multifieldNode : 1;
   unsigned int stopNode : 1;
   unsigned int initialize : 1;
   unsigned int marked : 1;
   unsigned int beginSlot : 1;
   unsigned int endSlot : 1;
  };

struct alphaMemoryHash
  {
   unsigned long bucket;
   struct patternNodeHeader *owner;
   struct partialMatch *alphaMemory;
   struct partialMatch *endOfQueue;
   struct alphaMemoryHash *nextHash;
   struct alphaMemoryHash *prevHash;
   struct alphaMemoryHash *next;
   struct alphaMemoryHash *prev;
  };

typedef struct alphaMemoryHash ALPHA_MEMORY_HASH;

#ifndef _H_ruledef
#include "ruledef.h"
#endif

struct joinNode
  {
   unsigned int firstJoin : 1;
   unsigned int logicalJoin : 1;
   unsigned int joinFromTheRight : 1;
   unsigned int patternIsNegated : 1;
   unsigned int initialize : 1;
   unsigned int marked : 1;
   unsigned int rhsType : 3;
   unsigned int depth : 7;
   long bsaveID;
   struct partialMatch *beta;
   struct partialMatch *notBeta;
   struct expr *networkTest;
   struct expr *leftHash;
   void *rightSideEntryStructure;
   struct joinNode *nextLevel;
   struct joinNode *lastLevel;
   struct joinNode *rightDriveNode;
   struct joinNode *rightMatchNode;
   struct defrule *ruleToActivate;
  };

#endif




